﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using System.Web;
using Microsoft.Reporting.WebForms;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DataExportVTAPatient : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                ReplacePageTitle();

                if (UserSession.IsRegistryAdministrator)
                {
                    ReportViewer1.Reset();
                    ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                    ReportViewer1.ServerReport.Timeout = (Timeout * 3000); //this timeout is in milliseconds
                    ReportViewer1.ServerReport.ReportServerUrl = new Uri(ReportServerUrl);
                    ReportViewer1.ServerReport.ReportPath = "/Reports/EFR/Sub/VTA Data Extract";
                    ReportViewer1.ServerReport.Refresh();
                }
                else
                    Response.Redirect("~/AccessDenied.aspx", false);
            }

            // Added for 508 compliance with GridView column headers and footer
            //Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridView1.ClientID + "');", true);
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
            //Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
            //Use the code below to explicitely convert affected columns into text format
            //Column numbers start with 0

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //MJ, 01/25/2011, Cells values are referenced by ColumnName instead of column Index
                GetCellsByBoundFieldName(e.Row, "SSN").ForEach(c => c.Attributes.Add("class", "text"));
                GetCellsByBoundFieldName(e.Row, "ICN").ForEach(c => c.Attributes.Add("class", "text"));
            }
        }

        private List<DataControlFieldCell> GetCellsByBoundFieldName(GridViewRow row, string fieldName)
        {
            return row.Cells.Cast<DataControlFieldCell>().Where(s => s.ContainingField.HeaderText.EndsWith(fieldName)).ToList();
        }

        protected void ObjectDataSource1_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            try
            {
                e.InputParameters.Clear();

                e.InputParameters.Add("CURRENT_USER", System.Web.HttpContext.Current.User.Identity.Name);
                e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
